//------------------------------------//
// reload button
//------------------------------------//

// ボタンを作ります
function createButton(element, handler) {
  // 通常の画像を設定します
  element.src = "images/" + element.name + ".png";
  // イベントハンドラを設定します
  element.addEventListener("mouseover", mouseOver, false);
  element.addEventListener("mouseout", mouseOut, false);
  element.addEventListener("mousedown", mouseDown, false);
  element.addEventListener("mouseup", mouseUp, false);
  // ボタンがクリックされたときのハンドラを設定します
  element.buttonClickAction = handler;
}

// マウスが上に来たときのハンドラです
function mouseOver(event) {
  var element = event.toElement;
  // ボタンが押されている場合
  if (element.isPressed == 1) {
    // 押されたボタンの画像を設定します
    element.src = "images/" + element.name + "Pressed.png";
  }
  else {
    // 強調画像を設定します
    element.src = "images/" + element.name + "Over.png";
  }
}

// マウスが外に出たときのハンドラです
function mouseOut(event) {
  var element = event.fromElement;
  // 通常の画像を設定します
  element.src = "images/" + element.name + ".png";
}

// マウスを押したときのハンドラです
function mouseDown(event) {
  var element = event.toElement;
  // 押されたボタンの画像を設定します
  element.src = "images/" + element.name + "Pressed.png";
  // ボタンの状態を設定します
  element.isPressed = 1;
}

// マウスを離したときのハンドラです
function mouseUp(event) {
  var element = event.toElement;
  // 通常の画像を設定します
  element.src = "images/" + element.name + ".png";
  // ボタンの状態をクリアします
  element.isPressed = 0;
  
  // ボタンクリックのハンドラを呼び出します
  element.buttonClickAction();
}
  // リロードボタンが押されたときにページをリドードするメソッドです
function reloadbuttonClicked() {
  location.reload();
}


